/*============================================================================
  File:     01b - CorrelatedQueriesLarge.sql

  SQL Server Versions: 2012, 2014, 2016, 2017, 2019
------------------------------------------------------------------------------
  Written by Jonathan Kehayias, SQLskills.com
  
  (c) 2019, SQLskills.com. All rights reserved.

  For more scripts and sample code, check out 
    http://www.SQLskills.com

  You may alter this code for your own *non-commercial* purposes. You may
  republish altered code as long as you include this copyright and give due
  credit, but you must obtain prior permission before blogging this code.
  
  THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF 
  ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED 
  TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
  PARTICULAR PURPOSE.
============================================================================*/

USE AdventureWorks2014
GO

SET NOCOUNT ON

DECLARE @StartTime DATETIME
SET @StartTime = GETDATE()

SELECT	ProductID, 
		ProductNumber,
		(
			SELECT SUM(LineTotal) SumTotal 
			FROM Sales.SalesOrderDetailEnlarged sd 
			WHERE sd.ProductID = p.ProductID 
		) as SumTotal,
		(
			SELECT SUM(LineTotal*UnitPriceDiscount) SumDiscount 
			FROM Sales.SalesOrderDetailEnlarged sd 
			WHERE sd.ProductID = p.ProductID 
		) as SumDiscount
FROM Production.Product p
WHERE ProductNumber like 'BK%'
  AND 	(
			SELECT SUM(LineTotal) SumTotal 
			FROM Sales.SalesOrderDetailEnlarged sd 
			WHERE sd.ProductID = p.ProductID 
		) IS NOT NULL
  AND	(
			SELECT SUM(LineTotal*UnitPriceDiscount) SumDiscount 
			FROM Sales.SalesOrderDetailEnlarged sd 
			WHERE sd.ProductID = p.ProductID 
		) > (
				SELECT SUM(LineTotal) SumTotal 
				FROM Sales.SalesOrderDetailEnlarged sd 
				WHERE sd.ProductID = p.ProductID 
			)*0.01

PRINT 'Duration with correlated subqueries: ' + CAST(DATEDIFF(ms, @StartTime, GETDATE()) AS varchar(10)) + ' ms'

SET @StartTime = GETDATE()

SELECT p.ProductID, ProductNumber, SumTotal, SumDiscount
FROM Production.Product p
INNER JOIN (
				SELECT ProductID, SUM(LineTotal) SumTotal, SUM(LineTotal*UnitPriceDiscount) SumDiscount 
				FROM Sales.SalesOrderDetailEnlarged 
				GROUP BY ProductID
				HAVING SUM(LineTotal*UnitPriceDiscount) > SUM(LineTotal)*0.01 
			) SalesTotals on p.ProductID = SalesTotals.ProductID
WHERE ProductNumber like 'BK%'

PRINT 'Duration with derived table: ' + CAST(DATEDIFF(ms, @StartTime, GETDATE()) AS varchar(10)) + ' ms'

